################################################################################
#
# evilwm
#
################################################################################

EVILWM_VERSION = 1.5
EVILWM_SITE = https://www.6809.org.uk/evilwm/dl
EVILWM_LICENSE = evilwm license
EVILWM_LICENSE_FILES = README

EVILWM_DEPENDENCIES = xlib_libX11 xlib_libXrandr

define EVILWM_INSTALL_XSESSION_FILE
	$(INSTALL) -m 0755 -D package/evilwm/xsession \
		$(TARGET_DIR)/root/.xsession
endef

EVILWM_POST_INSTALL_TARGET_HOOKS += EVILWM_INSTALL_XSESSION_FILE

EVILWM_TOOLS_PREFIX += $(patsubst %-,%,$(TARGET_CROSS))

# the configure script is not generated by autoconf
define EVILWM_CONFIGURE_CMDS
	(cd $(@D); $(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		LDFLAGS="$(TARGET_LDFLAGS)" \
		./configure \
		--prefix=/usr \
		--mandir=/usr/share/man \
		--host=$(EVILWM_TOOLS_PREFIX) \
	)
endef

define EVILWM_BUILD_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) -C $(@D)
endef

define EVILWM_INSTALL_TARGET_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) DESTDIR="$(TARGET_DIR)" -C $(@D) install
endef

$(eval $(generic-package))
