################################################################################
#
# libfreeimage
#
################################################################################

LIBFREEIMAGE_VERSION = 3.18.0
LIBFREEIMAGE_SITE = http://downloads.sourceforge.net/freeimage
LIBFREEIMAGE_SOURCE = FreeImage$(subst .,,$(LIBFREEIMAGE_VERSION)).zip
LIBFREEIMAGE_LICENSE = GPL-2.0 or GPL-3.0 or FreeImage Public License
LIBFREEIMAGE_LICENSE_FILES = license-gplv2.txt license-gplv3.txt license-fi.txt
LIBFREEIMAGE_CPE_ID_VENDOR = freeimage_project
LIBFREEIMAGE_CPE_ID_PRODUCT = freeimage
LIBFREEIMAGE_INSTALL_STAGING = YES

# 0007-CVE-2019-12211_2019-12213.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2019-12211 CVE-2019-12213

# 0008-CVE-2020-24292.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2020-24292

# 0009-CVE-2020-24293.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2020-24293

# 0010-CVE-2020-24295.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2020-24295

# 0011-CVE-2021-33367.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2021-33367

# 0012-CVE-2021-40263.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2021-40263

# 0013-CVE-2021-40266.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2021-40266

# 0014-CVE-2023-47995.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2023-47995

# 0016-CVE-2023-47997.patch
LIBFREEIMAGE_IGNORE_CVES += CVE-2023-47997

define LIBFREEIMAGE_EXTRACT_CMDS
	$(UNZIP) $(LIBFREEIMAGE_DL_DIR)/$(LIBFREEIMAGE_SOURCE) -d $(@D)
	mv $(@D)/FreeImage/* $(@D)
	rmdir $(@D)/FreeImage
endef

define LIBFREEIMAGE_BUILD_CMDS
	$(TARGET_MAKE_ENV) $(TARGET_CONFIGURE_OPTS) \
		CXXFLAGS="$(TARGET_CXXFLAGS) -std=c++11" $(MAKE) -C $(@D)
endef

define LIBFREEIMAGE_INSTALL_STAGING_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) -C $(@D) DESTDIR=$(STAGING_DIR) install
endef

define LIBFREEIMAGE_INSTALL_TARGET_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) -C $(@D) DESTDIR=$(TARGET_DIR) install
endef

$(eval $(generic-package))
