################################################################################
#
# flutter-pi
#
################################################################################

FLUTTER_PI_VERSION = 37bd9773c1938e5f76208bc4e8632fdbbb4190ff
FLUTTER_PI_SITE = https://github.com/ardera/flutter-pi.git
FLUTTER_PI_SITE_METHOD = git
FLUTTER_PI_LICENSE = MIT
FLUTTER_PI_LICENSE_FILES = LICENSE
FLUTTER_PI_DEPENDENCIES = \
	flutter-engine \
	libinput \
	libxkbcommon \
	systemd

FLUTTER_PI_CONF_OPTS = \
	-DDEBUG_DRM_PLANE_ALLOCATIONS=OFF \
	-DDUMP_ENGINE_LAYERS=OFF \
	-DENABLE_ASAN=OFF \
	-DENABLE_MTRACE=OFF \
	-DENABLE_SOFTWARE=OFF \
	-DENABLE_TESTS=OFF \
	-DENABLE_TSAN=OFF \
	-DENABLE_UBSAN=OFF \
	-DFILESYSTEM_LAYOUT=meta-flutter \
	-DLINT_EGL_HEADERS=OFF \
	-DTRY_BUILD_GSTREAMER_AUDIO_PLAYER_PLUGIN=OFF \
	-DTRY_BUILD_GSTREAMER_VIDEO_PLAYER_PLUGIN=OFF \
	-DTRY_ENABLE_OPENGL=OFF \
	-DTRY_ENABLE_SESSION_SWITCHING=OFF \
	-DTRY_ENABLE_VULKAN=OFF \
	-DVULKAN_DEBUG="OFF" \
	-DUSE_LEGACY_KMS=OFF \
	-DWARN_MISSING_FIELD_INITIALIZERS=OFF \
	-DBUILD_SENTRY_PLUGIN=OFF

ifeq ($(BR2_ENABLE_LTO),y)
FLUTTER_PI_CONF_OPTS += -DLTO=ON
else
FLUTTER_PI_CONF_OPTS += -DLTO=OFF
endif

ifeq ($(BR2_PACKAGE_FLUTTER_PI_CHARSET_CONVERTER_PLUGIN),y)
FLUTTER_PI_CONF_OPTS += -DBUILD_CHARSET_CONVERTER_PLUGIN=ON
else
FLUTTER_PI_CONF_OPTS += -DBUILD_CHARSET_CONVERTER_PLUGIN=OFF
endif

ifeq ($(BR2_PACKAGE_FLUTTER_PI_GSTREAMER_AUDIO_PLAYER_PLUGIN),y)
FLUTTER_PI_DEPENDENCIES += gstreamer1 gst1-plugins-base
FLUTTER_PI_CONF_OPTS += -DBUILD_GSTREAMER_AUDIO_PLAYER_PLUGIN=ON
else
FLUTTER_PI_CONF_OPTS += -DBUILD_GSTREAMER_AUDIO_PLAYER_PLUGIN=OFF
endif

ifeq ($(BR2_PACKAGE_FLUTTER_PI_GSTREAMER_VIDEO_PLAYER_PLUGIN),y)
FLUTTER_PI_DEPENDENCIES += gstreamer1 gst1-plugins-base
FLUTTER_PI_CONF_OPTS += -DBUILD_GSTREAMER_VIDEO_PLAYER_PLUGIN=ON
else
FLUTTER_PI_CONF_OPTS += -DBUILD_GSTREAMER_VIDEO_PLAYER_PLUGIN=OFF
endif

ifeq ($(BR2_PACKAGE_FLUTTER_PI_RAW_KEYBOARD_PLUGIN),y)
FLUTTER_PI_CONF_OPTS += -DBUILD_RAW_KEYBOARD_PLUGIN=ON
else
FLUTTER_PI_CONF_OPTS += -DBUILD_RAW_KEYBOARD_PLUGIN=OFF
endif

ifeq ($(BR2_PACKAGE_FLUTTER_PI_TEXT_INPUT_PLUGIN),y)
FLUTTER_PI_DEPENDENCIES += libinput libxkbcommon
FLUTTER_PI_CONF_OPTS += -DBUILD_TEXT_INPUT_PLUGIN=ON
else
FLUTTER_PI_CONF_OPTS += -DBUILD_TEXT_INPUT_PLUGIN=OFF
endif

ifeq ($(BR2_PACKAGE_MESA3D_VULKAN_DRIVER)$(BR2_PACKAGE_VULKAN_LOADER),yy)
FLUTTER_PI_DEPENDENCIES += mesa3d vulkan-loader
FLUTTER_PI_CONF_OPTS += -DENABLE_VULKAN=ON
else
FLUTTER_PI_CONF_OPTS += -DENABLE_VULKAN=OFF
endif

ifeq ($(BR2_PACKAGE_HAS_LIBGLES),y)
FLUTTER_PI_CONF_OPTS += -DENABLE_OPENGL=ON
else
FLUTTER_PI_CONF_OPTS += -DENABLE_OPENGL=OFF
endif

ifeq ($(BR2_PACKAGE_SEATD),y)
FLUTTER_PI_DEPENDENCIES += seatd
FLUTTER_PI_CONF_OPTS += -DENABLE_SESSION_SWITCHING=ON
else
FLUTTER_PI_CONF_OPTS += -DENABLE_SESSION_SWITCHING=OFF
endif

$(eval $(cmake-package))
