################################################################################
#
# firewalld
#
################################################################################

FIREWALLD_VERSION = 2.0.2
FIREWALLD_SITE = $(call github,firewalld,firewalld,v$(FIREWALLD_VERSION))
FIREWALLD_LICENSE = GPL-2.0
FIREWALLD_LICENSE_FILES = COPYING
FIREWALLD_CPE_ID_VENDOR = firewalld
FIREWALLD_AUTORECONF = YES

FIREWALLD_DEPENDENCIES = \
	host-intltool \
	host-libglib2 \
	host-libxml2 \
	host-libxslt \
	dbus-python \
	gobject-introspection \
	jansson \
	nftables \
	python3 \
	python-gobject

FIREWALLD_SELINUX_MODULES = firewalld

# Firewalld hard codes the python shebangs to the full path of the
# python-interpreter. IE: #!/home/buildroot/output/host/bin/python.
# Force the proper python path.
FIREWALLD_CONF_ENV += PYTHON="/usr/bin/env python3"

# /etc/sysconfig/firewalld is a Red Hat-ism, only referenced by
# the Red Hat-specific init script which isn't used, so we set
# --disable-sysconfig.
FIREWALLD_CONF_OPTS += \
	--disable-rpmmacros \
	--disable-sysconfig \
	--with-nft=/usr/sbin/nft \
	--without-ebtables \
	--without-ebtables-restore \
	--without-ipset \
	--without-xml-catalog

ifeq ($(BR2_PACKAGE_IPTABLES),y)
FIREWALLD_DEPENDENCIES += iptables
FIREWALLD_CONF_OPTS += \
	--with-ip6tables-restore=/usr/sbin/ip6tables-restore \
	--with-ip6tables=/usr/sbin/ip6tables \
	--with-iptables-restore=/usr/sbin/iptables-restore \
	--with-iptables=/usr/sbin/iptables
else
FIREWALLD_CONF_OPTS += -without-iptables
endif

ifeq ($(BR2_PACKAGE_SYSTEMD),y)
FIREWALLD_DEPENDENCIES += systemd
FIREWALLD_CONF_OPTS += --with-systemd-unitdir=/usr/lib/systemd/system
else
FIREWALLD_CONF_OPTS += --disable-systemd
endif

define FIREWALLD_INSTALL_INIT_SYSTEMD
	$(INSTALL) -D -m 0644 $(@D)/config/firewalld.service \
		$(TARGET_DIR)/usr/lib/systemd/system/firewalld.service
endef

# The bundled sysvinit file requires /etc/init.d/functions which is not
# provided by buildroot. As such, we provide our own firewalld init file.
define FIREWALLD_INSTALL_INIT_SYSV
	$(INSTALL) -D -m 0755 $(FIREWALLD_PKGDIR)/S46firewalld \
		$(TARGET_DIR)/etc/init.d/S46firewalld
endef

# Firewalld needs ipv6
# Firewalld requires almost every single nftable option selected.
define FIREWALLD_LINUX_CONFIG_FIXUPS
	$(call KCONFIG_ENABLE_OPT,CONFIG_BRIDGE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_INET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_INET_DIAG)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NETFILTER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NETFILTER_ADVANCED)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_FILTER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_IPTABLES)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MANGLE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_AH)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_EUI64)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_FRAG)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_HL)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_IPV6HEADER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_MH)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_OPTS)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_RPFILTER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_RT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_MATCH_SRH)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_NAT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_RAW)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_TARGET_HL)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_TARGET_MASQUERADE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_TARGET_NPT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_TARGET_REJECT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP6_NF_TARGET_SYNPROXY)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_ARP_MANGLE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_ARPFILTER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_ARPTABLES)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_FILTER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_IPTABLES)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_MANGLE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_MATCH_AH)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_MATCH_ECN)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_MATCH_RPFILTER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_MATCH_TTL)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_NAT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_RAW)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_CLUSTERIP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_ECN)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_MASQUERADE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_NETMAP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_REDIRECT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_REJECT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_SYNPROXY)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_NF_TARGET_TTL)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_BITMAP_IP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_BITMAP_IPMAC)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_BITMAP_PORT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_IP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_IPMAC)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_IPMARK)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_IPPORT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_IPPORTIP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_IPPORTNET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_MAC)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_NET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_NETIFACE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_NETNET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_NETPORT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_HASH_NETPORTNET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_IP_SET_LIST_SET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NETFILTER_CONNCOUNT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NETFILTER_NETLINK_GLUE_CT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NETFILTER_SYNPROXY)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NETFILTER_XTABLES)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_AMANDA)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_BROADCAST)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_EVENTS)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_FTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_H323)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_IRC)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_LABELS)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_MARK)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_NETBIOS_NS)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_PPTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_PROCFS)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_SANE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_SIP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_SNMP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_TFTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_TIMEOUT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_TIMESTAMP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CONNTRACK_ZONES)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CT_NETLINK)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CT_NETLINK_HELPER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CT_NETLINK_TIMEOUT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CT_PROTO_DCCP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CT_PROTO_GRE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CT_PROTO_SCTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_CT_PROTO_UDPLITE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_DEFRAG_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_DEFRAG_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_DUP_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_DUP_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_DUP_NETDEV)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_FLOW_TABLE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_FLOW_TABLE_INET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_FLOW_TABLE_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_FLOW_TABLE_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_LOG_ARP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_LOG_BRIDGE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_LOG_COMMON)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_LOG_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_LOG_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_LOG_NETDEV)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_AMANDA)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_FTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_H323)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_IRC)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_MASQUERADE_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_MASQUERADE_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_NEEDED)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_PPTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_PROTO_DCCP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_PROTO_GRE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_PROTO_SCTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_PROTO_UDPLITE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_REDIRECT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_SIP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_SNMP_BASIC)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_NAT_TFTP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_REJECT_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_REJECT_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_SOCKET_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_SOCKET_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TABLES_ARP)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TABLES_BRIDGE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TABLES_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TABLES_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TABLES_NETDEV)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TABLES_SET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TPROXY_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NF_TPROXY_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_BRIDGE_REJECT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_CHAIN_NAT_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_CHAIN_NAT_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_CHAIN_ROUTE_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_CHAIN_ROUTE_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_COMPAT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_CONNLIMIT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_COUNTER)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_CT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_DUP_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_DUP_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_DUP_NETDEV)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_FIB)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_FIB_INET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_FIB_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_FIB_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_FIB_NETDEV)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_FLOW_OFFLOAD)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_FWD_NETDEV)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_HASH)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_LIMIT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_LOG)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_MASQ)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_MASQ_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_MASQ_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_NAT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_NUMGEN)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_OBJREF)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_OSF)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_QUEUE)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_QUOTA)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REDIR)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REDIR_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REDIR_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REJECT)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REJECT_INET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REJECT_IPV4)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REJECT_IPV6)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_REJECT_NETDEV)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_SOCKET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_SYNPROXY)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_TPROXY)
	$(call KCONFIG_ENABLE_OPT,CONFIG_NFT_TUNNEL)
endef

$(eval $(autotools-package))
