################################################################################
#
# mjpg-streamer
#
################################################################################

MJPG_STREAMER_VERSION = 5a6e0a2db163e6ae9461552b59079870d0959340
MJPG_STREAMER_SITE = $(call github,jacksonliam,mjpg-streamer,$(MJPG_STREAMER_VERSION))
MJPG_STREAMER_SUBDIR = mjpg-streamer-experimental
MJPG_STREAMER_LICENSE = GPL-2.0+
MJPG_STREAMER_LICENSE_FILES = $(MJPG_STREAMER_SUBDIR)/LICENSE
MJPG_STREAMER_DEPENDENCIES = jpeg

ifeq ($(BR2_PACKAGE_LIBGPHOTO2),y)
MJPG_STREAMER_CONF_OPTS += -DPLUGIN_INPUT_PTP2=ON
MJPG_STREAMER_DEPENDENCIES += host-pkgconf libgphoto2
else
MJPG_STREAMER_CONF_OPTS += -DPLUGIN_INPUT_PTP2=OFF
endif

ifeq ($(BR2_PACKAGE_LIBV4L),y)
MJPG_STREAMER_DEPENDENCIES += libv4l
endif

ifeq ($(BR2_PACKAGE_OPENCV3_LIB_HIGHGUI)$(BR2_PACKAGE_OPENCV3_LIB_IMGPROC)$(BR2_PACKAGE_OPENCV3_LIB_VIDEOIO),yyy)
MJPG_STREAMER_CONF_OPTS += \
	-DPLUGIN_INPUT_OPENCV=ON \
	-DPLUGIN_CVFILTER_CPP=OFF \
	-DPLUGIN_CVFILTER_PY=OFF
MJPG_STREAMER_DEPENDENCIES += host-pkgconf opencv3
else
MJPG_STREAMER_CONF_OPTS += -DPLUGIN_INPUT_OPENCV=OFF
endif

ifeq ($(BR2_PACKAGE_PROTOBUF_C)$(BR2_PACKAGE_ZEROMQ),yy)
MJPG_STREAMER_CONF_OPTS += -DPLUGIN_OUTPUT_ZMQSERVER=ON
MJPG_STREAMER_DEPENDENCIES += host-pkgconf protobuf-c zeromq
else
MJPG_STREAMER_CONF_OPTS += -DPLUGIN_OUTPUT_ZMQSERVER=OFF
endif

ifeq ($(BR2_PACKAGE_SDL),y)
MJPG_STREAMER_CONF_OPTS += -DPLUGIN_OUTPUT_VIEWER=ON
MJPG_STREAMER_DEPENDENCIES += host-pkgconf sdl
else
MJPG_STREAMER_CONF_OPTS += -DPLUGIN_OUTPUT_VIEWER=OFF
endif

$(eval $(cmake-package))
